# rhocalc.R  
# Test Ho: rho = rho_0 where rho_0 is non-zero
# Load necessary libraries

# Input sample size, rho, and rho_0
n <- 10
r <- 0.787
rho_0 <- 0.5
zs <- sqrt(n-3)*(atanh(r)-atanh(rho_0))
#  P-value for two-tailed test
p_value2 <- 2*(1 - pnorm(abs(zs)))
# P-values for one-tailed tests
# Ho: rho = rho_0 vs. H1: rho > rho_0
p_val_gt <- 1 - pnorm(zs)
# Ho: rho = rho_0 vs. H1: rho < rho_0
p_val_lt <- pnorm(zs);

# Print test results
results <- data.frame(n,r,rho_0,zs,p_value2,p_val_gt,p_val_lt)
results



